// ****************************************************************************
// GlottalImageExplorer.
// Copyright (C) 2015-2016 Peter Birkholz.
// This program is free and open-source software.
// ****************************************************************************

#include <fstream>
#include "PlaybackThread.h"
#include <wx/stopwatch.h>


// ****************************************************************************
/// Constructor.
// ****************************************************************************

PlaybackThread::PlaybackThread(wxWindow *window) : wxThread()
{
  this->window = window;
  canceled = false;
  firstFrame = 0;
  lastFrame = 0;
}

// ****************************************************************************
/// Sets the range of frames to play.
// ****************************************************************************

void PlaybackThread::setFrameRange(int firstFrame, int lastFrame)
{
  this->firstFrame = firstFrame;
  this->lastFrame = lastFrame;
}


// ****************************************************************************
/// This is the acutal thread code.
// ****************************************************************************

void *PlaybackThread::Entry()
{
  Data *data = Data::getInstance();
  int i;
  
  // ****************************************************************
  // Restrict the synthesis speed.
  // ****************************************************************

  if (data->playbackSpeed_percent < 0)
  {
    data->playbackSpeed_percent = 0;
  }
  if (data->playbackSpeed_percent > 100)
  {
    data->playbackSpeed_percent = 100;
  }

  int pause_ms = (100 - data->playbackSpeed_percent);

  // ****************************************************************
  // Main loop.
  // ****************************************************************

  for (i = firstFrame; (i <= lastFrame) && (wasCanceled() == false); i++)
  {
    // Check if we were asked to exit
    if (TestDestroy())
    {
      break;
    }

    // Get the new film frame to display.

    data->frameIndex[0] = i;

    // **************************************************************
    // Create any type of command event here to send the current
    // film frame index in a thread-safe way.
    // **************************************************************

    // Set guiUpdateFinished to false BEFORE the command event is
    // sent to the GUI
    guiUpdateFinished = false;

    wxCommandEvent event(wxEVT_COMMAND_MENU_SELECTED, PLAYBACK_THREAD_EVENT);
    event.SetInt((i - firstFrame)*100 / (lastFrame - firstFrame + 1));    // Set the current frame index as payload for the message
    wxPostEvent(window, event);

    // Wait until the GUI update in response to our event finished.
    while (guiUpdateFinished == false)
    {
      // Give the rest of the thread time slice to the system allowing the other threads to run.
      this->Yield();   
    }

    // Wait a little bit
    Sleep(pause_ms);
  }

  // ****************************************************************
  // Send an event to the GUI thread that tells it that this thread
  // has finished.
  // ****************************************************************

  wxCommandEvent event( wxEVT_COMMAND_MENU_SELECTED, PLAYBACK_THREAD_EVENT );
  event.SetInt(-1); // that's all
  wxPostEvent(window, event);

  return NULL;
}


// ****************************************************************************
// ****************************************************************************

void PlaybackThread::OnExit()
{
}

// ****************************************************************************
